using System;
using System.Collections.Generic;
using System.Text;
using Server;
using Server.Network;
using LuaInterface;

namespace Server.Engines.Lua
{
	public interface ILuaCodeConsumer
	{
		LuaInterface.Lua Lua
		{
			get;
		}

		LuaCode Code
		{
			get;
			set;
		}

		string Script
		{
			get;
			set;
		}

		string Description
		{
			get;
		}

		void OnLostSubscription();
		void OnScriptChanged();
	}

	public class LuaFunctionResult
	{
		private object[] m_Results = null;

		public object[] Results
		{
			get { return m_Results; }
			set { m_Results = value; }
		}

		public LuaFunctionResult()
		{
		}

		public LuaFunctionResult( object[] results )
		{
			m_Results = results;
		}

		public object Get( int index, object defaultValue )
		{
			if ( m_Results != null && m_Results.Length > 0 && index > -1 && index < m_Results.Length )
			{
				return m_Results[index];
			}

			return defaultValue;
		}

		public int AsInteger( int index, int defaultValue )
		{
			return (int)Get( index, defaultValue );
		}

		public bool AsBoolean( int index, bool defaultValue )
		{
			return (bool)Get( index, defaultValue );
		}

		public string AsString( int index, string defaultValue )
		{
			return (string)Get( index, defaultValue );
		}
	}

	public class LuaHelper
	{
		public static LuaFunctionResult CallFunction( ILuaCodeConsumer caller, string function, params object[] args )
		{
			LuaFunctionResult result = new LuaFunctionResult();
			
         if (caller == null)
            return result;

			LuaFunction luaFunction = caller.Lua.GetFunction( function );

			if ( luaFunction == null )
				return result;

			try
			{
				result.Results = luaFunction.Call( args );
			}
			catch ( Exception e )
			{
				BroudcastError( caller, e.Message );
			}

			return result;
		}

		public static void BroudcastError( ILuaCodeConsumer sender, string message )
		{
			lock ( NetState.Instances )
			{
				foreach ( NetState netstate in NetState.Instances )
				{
					Mobile player = netstate.Mobile;

					if ( player.AccessLevel >= AccessLevel.GameMaster )
					{
						player.SendMessage( 38, "Lua error: {0}, {1}", sender.Description, message );
					}
				}
			}
		}
	}
}
